---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：25-Metadata API

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **C-16**：metadata/generateMetadata/viewport/generateViewportの同一セグメント共存不可制約の根拠確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/lib/metadata/resolve-metadata.ts` - メタデータ解決メインロジック（1308行）
- E-02: `packages/next/src/lib/metadata/types/metadata-interface.ts` - Metadata型定義
- E-03: `packages/next/src/lib/metadata/types/opengraph-types.ts` - OpenGraph型定義
- E-04: `packages/next/src/lib/metadata/types/twitter-types.ts` - Twitter型定義
- E-05: `packages/next/src/lib/metadata/resolvers/resolve-title.ts` - title解決
- E-06: `packages/next/src/lib/metadata/resolvers/resolve-opengraph.ts` - OpenGraph解決
- E-07: `packages/next/src/lib/metadata/resolvers/resolve-icons.ts` - アイコン解決
- E-08: `packages/next/src/lib/metadata/resolvers/resolve-basics.ts` - 基本メタデータ解決
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | resolveMetadata()がメインエントリーポイント | E-01 (1257-1279行目) | ○ |
| C-02 | resolveMetadataItemsImplでローダーツリーを再帰走査 | E-01 (731-798行目) | ○ |
| C-03 | collectMetadataで各セグメントのmetadata収集 | E-01 (608-656行目) | ○ |
| C-04 | accumulateMetadataで累積マージ | E-01 (1106-1218行目) | ○ |
| C-05 | mergeMetadataでプロパティ別マージ | E-01 (213-446行目) | ○ |
| C-06 | 子セグメントのメタデータが親を上書き | E-01 (1166-1174行目) | ○ |
| C-07 | title templateの適用 | E-01 (1178-1184行目), E-05 | ○ |
| C-08 | OpenGraphからTwitterへの自動継承 | E-01 (930-1001行目) postProcessMetadata | ○ |
| C-09 | favicon特別処理（i<=1でシフト） | E-01 (1138-1143行目) | ○ |
| C-10 | ファイルベースOGP/Twitter画像はコード定義未設定時のみ適用 | E-01 (182-202行目) mergeStaticMetadata | ○ |
| C-11 | viewport関連プロパティのmetadata内使用は警告 | E-01 (421-429行目) | ○ |
| C-12 | prerenderMetadataでgenerateMetadata事前実行 | E-01 (1005-1017行目) | ○ |
| C-13 | Reactのcache()でメモ化 | E-01 (707行目) resolveMetadataItems | ○ |
| C-14 | use cache対応のgenerateMetadataはlazy実行 | E-01 (1051-1059行目) | ○ |
| C-15 | server-onlyインポートによるServer Components専用 | E-01 (29行目) | ○ |
| C-16 | metadata/generateMetadataは同一セグメントで共存不可 | **根拠なし** (実装での排他チェック未確認) | △ |

## 4) 不足情報（Unknown / Missing）
- metadata/generateMetadataの同一セグメント共存時のエラー処理箇所が未確認
  - 候補：`packages/next/src/build/webpack/loaders/next-app-loader/index.ts`内のバリデーション

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メタデータ解決の主要フローは詳細に確認済み
- 0: 低リスク - 各resolverの実装は対応ファイルで確認可能
- 0: 低リスク - postProcessMetadataのOG/Twitter継承ロジックは明確

## 6) レビュアーチェックリスト（最小）
- [ ] resolveMetadataItemsImplの再帰走査がツリーを正しくトラバースするか確認
- [ ] mergeMetadataの各keyのswitch文が全プロパティをカバーしているか確認
- [ ] metadata/generateMetadataの共存チェック箇所を確認
